﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Inet.Viewer.Data;
using Inet.Viewer.Resources;
using System.Threading;

namespace Inet.Viewer.WinForms.Prompt
{
    /// <summary>
    /// Panel for a date prompt field
    /// </summary>
    public partial class DatePromptField : PromptControl
    {
        private DateTime oldValueIfNoValueNotChecked;

        /// <summary>
        /// simple constructor with the necessary dependencies
        /// </summary>
        /// <param name="p">prompt field this panel is based one</param>
        /// <param name="hideNoValue">flag indicating whether to hide the no-value checkbox</param>
        public DatePromptField(PromptData p, bool hideNoValue)
        {
            this.PromptData = p;

            InitializeComponent();

            bool dateOnly = p.Type == PromptData.Date;
            dateTimePicker1.Format = DateTimePickerFormat.Custom;
            dateTimePicker1.CustomFormat = dateOnly ? Thread.CurrentThread.CurrentCulture.DateTimeFormat.LongDatePattern : Thread.CurrentThread.CurrentCulture.DateTimeFormat.LongDatePattern + " " + Thread.CurrentThread.CurrentCulture.DateTimeFormat.ShortTimePattern;

            PromptValue alreadySelectedValue = p.Values;
            chkNoValue.Visible = p.MinValue == null && !hideNoValue;
            if (alreadySelectedValue != null && alreadySelectedValue.Value is DateTime)
            {
                dateTimePicker1.Value = (DateTime)alreadySelectedValue.Value;
            }
            else if (chkNoValue.Visible)
            {
                chkNoValue.Checked = true;
            }
            chkNoValue.Text = strings.Prompt_None_Long;

            ErrorProvider = errorProvider;
            ControlForErrors = chkNoValue.Visible ? (Control)chkNoValue : (Control)dateTimePicker1;
        }

        /// <summary>
        /// Returns the chosen value for this panel. Never null: if null value, will return null wrapped in a SinglePromptValue.
        /// </summary>
        internal override PromptValue Value
        {
            get
            {
                return new SinglePromptValue(chkNoValue.Checked ? null : (object)dateTimePicker1.Value, null, PromptData.Type);
            }
            set
            {
                DateTime? dateTime = (DateTime?)value.Value;
                dateTimePicker1.Value = dateTime == null ? DateTime.Now : (DateTime)dateTime;
            }
        }

        /// <summary>
        /// Called when the "no value" checkbox is checked: sets the value to null
        /// </summary>
        /// <param name="sender">button being checked</param>
        /// <param name="e">args of the event</param>
        void chkNoValue_CheckedChanged(object sender, EventArgs e)
        {
            if (this.chkNoValue.Checked)
            {
                oldValueIfNoValueNotChecked = this.dateTimePicker1.Value;
                this.dateTimePicker1.Enabled = false;
            }
            else
            {
                if (oldValueIfNoValueNotChecked == null)
                {
                    oldValueIfNoValueNotChecked = new DateTime();
                }
                this.dateTimePicker1.Value = oldValueIfNoValueNotChecked;
                this.dateTimePicker1.Enabled = true;
            }
        }

        private void dateTimePicker1_ValueChanged(object sender, EventArgs e)
        {
            HandleChanged(sender, e);
        }
    }
}
